#include <iostream>
#include <algorithm>
#include <stack>

using namespace std;

static int najveca_udaljenost = 1'000'000'000;

struct Jarbol{
    int x;
    int h;
    int i;
};

int rastojanje(Jarbol *a, Jarbol *b) {
    return abs(a->x - b->x) - abs(a->h - b->h);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    cin >> n;
    
    Jarbol svi_jarboli[n];
    for(int i = 0; i < n; i++) {
        cin >> svi_jarboli[i].x;
        svi_jarboli[i].i = i;
    }
    for(int i = 0; i < n; i++)
        cin >> svi_jarboli[i].h;
    
    sort(svi_jarboli, svi_jarboli + n, [](const Jarbol &a, const Jarbol &b) {
        return a.x < b.x;
    });
    
    int udaljenost[n];
    for(int i = 0; i < n; i++)
        udaljenost[i] = najveca_udaljenost;
    stack<Jarbol*> jarboli;
    jarboli.push(&svi_jarboli[0]);
    for(int i = 1; i < n; i++) {
        while(jarboli.top()->h <= svi_jarboli[i].h) {
            Jarbol *jarbol = jarboli.top();
            jarboli.pop();
            
            if(jarboli.empty()) {
                udaljenost[jarbol->i] = rastojanje(jarbol, &svi_jarboli[i]);
                break;
            }
            
            udaljenost[jarbol->i] = min(rastojanje(jarboli.top(), jarbol), rastojanje(jarbol, &svi_jarboli[i]));
        }
        jarboli.push(&svi_jarboli[i]);
    }
    while(!jarboli.empty()) {
        Jarbol *jarbol = jarboli.top();
        jarboli.pop();
        
        if(!jarboli.empty()) {
            udaljenost[jarbol->i] = min(udaljenost[jarbol->i], rastojanje(jarboli.top(), jarbol));
            if(jarbol->h == jarboli.top()->h)
                udaljenost[jarboli.top()->i] = udaljenost[jarbol->i];
        }else if(udaljenost[jarbol->i] == najveca_udaljenost)
            udaljenost[jarbol->i] = -1;
    }
    
    for(int i = 0; i < n; i++)
        cout << udaljenost[i] << '\n';
    
    return 0;
}